function [fy] = eccatenariafd(y,x,C)
%
% [fx] = eccatenariafd(y,x,C)
%
% Devuelve en fx la aproximacion de diferencias finitas a la ecuacion de
% la catenaria evaluada en los valores de y. Supone malla equiespaciada.
%
% ENTRADA
%   y     array de valores de la incognita
%         y(1) e y(end) contienen los valores de las condiciones de
%         contorno
%   x     array de valores de la variable independiente
%   C     rho/T para la catenaria
%
% SALIDA
%   fx    aproximacion de diferencias finitas de la ecuacion de la 
%         catenaria (correspondientes a la forma F(Y) = 0).
%
n = length(y); % dimension de los arrays
dx = x(2) - x(1);
d2 = ( y( 3:end ) - 2*y( 2:end-1 ) + y( 1:end-2 ) )/dx^2;
d1 = ( y( 3:end ) - y( 1:end-2 ) ) / ( 2.0 * dx);
fy = d2 - C*sqrt( 1.0 + d1.^2 );
